﻿using System;
using System.Collections.Generic;
using VeteransAffairs.Registries.BusinessAHOBPR.PaymentService;

using System.Diagnostics;
using System.Linq;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public class PaymentServiceImporter
    {
        protected eMISPaymentServicePortTypesClient _client;
        public PaymentServiceImporter()
        {
            _client = new eMISPaymentServicePortTypesClient();
            InputHeaderInfo = new InputHeaderInfo();
        }
        public InputHeaderInfo InputHeaderInfo
        {
            get;
            set;
        }

        /// <summary>
        /// Create a InputEdipiIcn which then can be used to create an inputEdiPiOrIcn class which is used
        /// to create a getDeploymentRequest.
        /// </summary>
        /// <param name="edipi"></param>
        /// <returns></returns>
        public static InputEdipiIcn CreateUppercasedEdipi(string edipi)
        {
            var inputEdipi = new InputEdipiIcn();
            inputEdipi.edipiORicnValue = edipi;
            inputEdipi.inputType = InputEdipiIcnInputType.EDIPI;
            return inputEdipi;
        }

        public List<PayGradeHistory> GetPaymentServiceData(string edipi)
        {
            if (string.IsNullOrEmpty(edipi)) throw new ArgumentNullException(nameof(edipi));
            eMISpayGradeHistoryResponseType response = CallEmis(edipi);
            if(response.payGradeHistory == null)
            {
                return new List<PayGradeHistory>();
            }
            return response.payGradeHistory.ToList();
        }

        /// <summary>
        /// You need to add an InputEdipiIcn to create a different class inputEdiPiOrIcn class that is used to create 
        /// a Request
        /// </summary>
        /// <param name="edipi"></param>
        /// <returns></returns>
        public static inputEdiPiOrIcn CreateHeader(string edipi)
        {
            InputEdipiIcn upperCasedEdipi = CreateUppercasedEdipi(edipi);
            var input = new inputEdiPiOrIcn();
            input.edipiORicn = upperCasedEdipi;
            return input;
        }
        public eMISpayGradeHistoryResponseType CallEmis(inputEdiPiOrIcn edipi, InputHeaderInfo headerInfo)
        {
            eMISpayGradeHistoryResponseType response = null;
            try
            {
                response = _client.getPayGradeHistory(ref headerInfo, edipi);
            }
            catch (Exception ex)
            {
                Trace.WriteLine("Exception: PaymentServiceImporter.CallEmis: " + ex.Message + "\n" + ex.StackTrace);
                AHOBPRLogger.LogErrorMessage("Exception", this.GetType().Name + "." + System.Reflection.MethodBase.GetCurrentMethod().Name, ex.StackTrace);
            }
            return response;
        }

        public eMISpayGradeHistoryResponseType CallEmis(string edipi)
        {
            var inputEdipiIcn = CreateHeader(edipi);
            return CallEmis(inputEdipiIcn, InputHeaderInfo);
        }


    }
}
